/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWEventDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassListCellRenderer;
import filenet.vw.toolkit.design.property.dialog.VWWorkClassProxy;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWAdvancedFieldNameCellEditor;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.design.property.tables.VWWFCAssignmentsTableModel;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWWaitForConditionDialog
extends VWModalDialog
implements ActionListener,
IVWDialogButtonsActionListener,
TableModelListener,
ListSelectionListener,
IVWExpressionTextFieldListener {
    private VWToolbarBorder m_conditionBorder = null;
    private JLabel m_workflowNameLabel = null;
    private JComboBox m_workflowNameComboBox = null;
    private JLabel m_expressionDataTypeLabel = null;
    private JTextField m_expressionDataTypeTextField = null;
    private JPanel m_conditionPanel = null;
    private JLabel m_conditionIdentifierLabel = null;
    private JTextField m_conditionIdentifierTextField = null;
    private JLabel m_operatorLabel = null;
    private JComboBox m_operatorComboBox = null;
    private JLabel m_expressionLabel = null;
    private VWExpressionTextField m_expressionTextField = null;
    private VWToolbarBorder m_actionBorder = null;
    private JLabel m_mapLabel = null;
    private JComboBox m_mapComboBox = null;
    private JLabel m_assignmentsLabel = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JButton m_deleteButton = null;
    private VWTable m_assignmentsTable = null;
    private VWWFCAssignmentsTableModel m_assignmentsTableModel = null;
    private VWAdvancedFieldNameCellEditor m_assignmentLValueCellEditor = null;
    private VWExpressionCellEditor m_assignmentRValueCellEditor = null;
    private VWDialogButtons m_dialogButtons = null;
    private GridBagConstraints m_gbCons = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWEventDefinition m_eventDef = null;
    private boolean m_isFirstTime = true;

    public VWWaitForConditionDialog(Dialog parent, VWAuthPropertyData authPropertyData, VWEventDefinition eventDef) {
        super(parent);
        this.m_authPropertyData = authPropertyData;
        this.m_eventDef = eventDef;
        this.setTitle(VWResource.s_conditionParametersStr);
        Dimension dim = VWStringUtils.stringToDimension("495,445");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(new Dimension(450, 400));
        }
        this.initControls();
    }

    public VWWaitForConditionDialog(Frame parent, VWAuthPropertyData authPropertyData, VWEventDefinition eventDef) {
        super(parent);
        this.m_authPropertyData = authPropertyData;
        this.m_eventDef = eventDef;
        this.setTitle(VWResource.s_conditionParametersStr);
        Dimension dim = VWStringUtils.stringToDimension("495,445");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(new Dimension(450, 400));
        }
        this.initControls();
    }

    public void reinitialize() {
        this.initOperatorComboBox();
        this.initExpressionControl();
        this.initWorkflowNameComboBox();
        this.initMapComboBox();
        this.m_assignmentsTableModel.reinitialize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_isFirstTime) {
            this.m_isFirstTime = false;
            if (this.m_assignmentsTable != null) {
                this.m_assignmentsTable.fitColumnsInTable();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_mapComboBox) {
            this.performMapAction();
        } else if (src == this.m_workflowNameComboBox) {
            this.performWorkflowNameAction();
        } else if (src == this.m_operatorComboBox) {
            this.performOperationAction();
        } else if (src == this.m_upButton) {
            this.performMoveUpAction();
        } else if (src == this.m_downButton) {
            this.performMoveDownAction();
        } else if (src == this.m_deleteButton) {
            this.performDeleteAction();
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        if (event.getSource().equals(this.m_dialogButtons)) {
            switch (event.getID()) {
                case 4: {
                    this.m_assignmentsTable.stopEditing();
                    this.setVisible(false);
                    break;
                }
                case 32: {
                    VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh160.htm");
                }
            }
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_assignmentsTable.getSelectedRow()) {
                    this.m_assignmentsTable.clearSelection();
                }
                this.m_assignmentsTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_upButton.setEnabled(false);
            this.m_downButton.setEnabled(false);
            this.m_deleteButton.setEnabled(false);
            int nRowIndex = this.m_assignmentsTable.getSelectedRow();
            if (this.m_assignmentsTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_assignmentsTableModel.getRowCount()) - 1) {
                this.m_upButton.setEnabled(true);
                this.m_downButton.setEnabled(true);
                this.m_deleteButton.setEnabled(true);
                if (nRowIndex == nRowCount - 2) {
                    this.m_downButton.setEnabled(false);
                }
                if (nRowIndex == 0) {
                    this.m_upButton.setEnabled(false);
                }
            }
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_expressionTextField) {
            this.onExpressionUpdated();
        }
    }

    private void initControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initConditionControls();
        this.initActionControls();
        this.initDialogControls();
        this.reinitialize();
    }

    private void initConditionControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(5, 5, 0, 5);
        this.m_conditionBorder = new VWToolbarBorder(VWResource.s_conditionStr);
        this.getContentPane().add((Component)this.m_conditionBorder, this.m_gbCons);
        JPanel conditionPanel = this.m_conditionBorder.getClientPanel();
        conditionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_workflowNameLabel = new JLabel(VWResource.s_workflowNameStr);
        conditionPanel.add((Component)this.m_workflowNameLabel, gbCons);
        ++gbCons.gridy;
        this.m_workflowNameComboBox = new JComboBox();
        this.m_workflowNameComboBox.addActionListener(this);
        this.m_workflowNameComboBox.setRenderer(new VWWorkClassListCellRenderer());
        conditionPanel.add((Component)this.m_workflowNameComboBox, gbCons);
        ++gbCons.gridy;
        this.m_expressionDataTypeLabel = new JLabel(VWResource.s_expressionDataTypeStr);
        conditionPanel.add((Component)this.m_expressionDataTypeLabel, gbCons);
        ++gbCons.gridy;
        this.m_expressionDataTypeTextField = new JTextField();
        this.m_expressionDataTypeTextField.setEditable(false);
        conditionPanel.add((Component)this.m_expressionDataTypeTextField, gbCons);
        ++gbCons.gridy;
        this.m_conditionPanel = this.createConditionPanel();
        conditionPanel.add((Component)this.m_conditionPanel, gbCons);
    }

    private JPanel createConditionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 2, 0);
        this.m_conditionIdentifierLabel = new JLabel(VWResource.s_conditionIdentifierStr);
        panel.add((Component)this.m_conditionIdentifierLabel, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 0;
        gbCons.gridy = 1;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 2, 2);
        this.m_conditionIdentifierTextField = new JTextField();
        this.m_conditionIdentifierTextField.setEditable(false);
        panel.add((Component)this.m_conditionIdentifierTextField, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 1;
        gbCons.gridy = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 2, 0);
        this.m_operatorLabel = new JLabel(VWResource.s_operatorStr);
        panel.add((Component)this.m_operatorLabel, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 1;
        gbCons.gridy = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 2);
        this.m_operatorComboBox = new JComboBox();
        this.m_operatorComboBox.setRenderer(new VWLabelListCellRenderer());
        panel.add((Component)this.m_operatorComboBox, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 2;
        gbCons.gridx = 2;
        gbCons.gridy = 0;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_expressionLabel = new JLabel(VWResource.s_expressionStr);
        panel.add((Component)this.m_expressionLabel, gbCons);
        gbCons.anchor = 23;
        gbCons.fill = 1;
        gbCons.gridx = 2;
        gbCons.gridy = 1;
        gbCons.weightx = 0.5;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 2);
        this.m_expressionTextField = new VWExpressionTextField(this, (IVWPropertyData)this.m_authPropertyData);
        panel.add((Component)this.m_expressionTextField, gbCons);
        return panel;
    }

    private void initActionControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 5, 5, 5);
        this.m_actionBorder = new VWToolbarBorder(VWResource.s_actionStr);
        this.getContentPane().add((Component)this.m_actionBorder, this.m_gbCons);
        JPanel actionPanel = this.m_actionBorder.getClientPanel();
        actionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 21;
        gbCons.fill = 2;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_assignmentsLabel = new JLabel(VWResource.s_assignmentsStr);
        actionPanel.add((Component)this.m_assignmentsLabel, gbCons);
        gbCons.anchor = 24;
        gbCons.fill = 0;
        gbCons.gridx = 1;
        gbCons.gridy = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_upButton = (JButton)VWImageLoader.createToolBarButton("up.gif", VWResource.s_moveUp, false);
        this.m_upButton.addActionListener(this);
        this.m_upButton.setEnabled(false);
        actionPanel.add((Component)this.m_upButton, gbCons);
        gbCons.anchor = 24;
        gbCons.fill = 0;
        gbCons.gridx = 2;
        gbCons.gridy = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_downButton = (JButton)VWImageLoader.createToolBarButton("down.gif", VWResource.s_moveDown, false);
        this.m_downButton.addActionListener(this);
        this.m_downButton.setEnabled(false);
        actionPanel.add((Component)this.m_downButton, gbCons);
        gbCons.anchor = 24;
        gbCons.fill = 0;
        gbCons.gridx = 3;
        gbCons.gridy = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_deleteButton = (JButton)VWImageLoader.createToolBarButton("delete.gif", VWResource.s_deleteStr, false);
        this.m_deleteButton.addActionListener(this);
        this.m_deleteButton.setEnabled(false);
        actionPanel.add((Component)this.m_deleteButton, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.weighty = 1.0;
        gbCons.gridwidth = 4;
        gbCons.anchor = 23;
        gbCons.fill = 1;
        this.m_assignmentsTableModel = new VWWFCAssignmentsTableModel(this.m_authPropertyData, this.m_eventDef);
        this.m_assignmentsTableModel.addTableModelListener(this);
        this.m_assignmentsTable = new VWTable(this.m_assignmentsTableModel);
        this.m_assignmentsTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_assignmentsTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        this.m_assignmentsTable.getSelectionModel().addListSelectionListener(this);
        this.m_assignmentsTable.getSelectionModel().setSelectionMode(0);
        TableColumn tcElement = this.m_assignmentsTable.getColumnModel().getColumn(0);
        if (tcElement != null) {
            this.m_assignmentLValueCellEditor = new VWAdvancedFieldNameCellEditor(this.m_authPropertyData, true);
            tcElement.setCellEditor(this.m_assignmentLValueCellEditor);
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        if ((tcElement = this.m_assignmentsTable.getColumnModel().getColumn(1)) != null) {
            this.m_assignmentRValueCellEditor = new VWExpressionCellEditor((IVWPropertyData)this.m_authPropertyData, 101);
            tcElement.setCellEditor(this.m_assignmentRValueCellEditor);
            tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
        }
        actionPanel.add((Component)new JScrollPane(this.m_assignmentsTable), gbCons);
        gbCons.fill = 2;
        ++gbCons.gridy;
        gbCons.weighty = 0.0;
        this.m_mapLabel = new JLabel(VWResource.s_mapStr);
        actionPanel.add((Component)this.m_mapLabel, gbCons);
        ++gbCons.gridy;
        this.m_mapComboBox = new JComboBox();
        this.m_mapComboBox.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
        this.m_mapComboBox.addActionListener(this);
        actionPanel.add((Component)this.m_mapComboBox, gbCons);
    }

    private void initDialogControls() {
        this.m_gbCons.anchor = 10;
        this.m_gbCons.fill = 0;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 2;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(5, 5, 5, 5);
        this.m_dialogButtons = new VWDialogButtons(36);
        this.m_dialogButtons.addDialogButtonsActionListener(this);
        this.getContentPane().add((Component)this.m_dialogButtons, this.m_gbCons);
    }

    private void initWorkflowNameComboBox() {
        block5: {
            try {
                if (this.m_authPropertyData == null) break block5;
                VWWorkClassProxy[] workClasses = VWWorkClassProxy.getAvailableWorkClasses(this.m_authPropertyData);
                DefaultComboBoxModel<VWWorkClassProxy> cbModel = new DefaultComboBoxModel<VWWorkClassProxy>(workClasses);
                this.m_workflowNameComboBox.removeActionListener(this);
                this.m_workflowNameComboBox.setModel(cbModel);
                String workflowName = this.m_eventDef.getWorkClassName();
                if (workflowName != null && workflowName.length() > 0) {
                    VWWorkClassProxy proxyItem = null;
                    for (int nIndex = 0; nIndex < cbModel.getSize(); ++nIndex) {
                        proxyItem = (VWWorkClassProxy)this.m_workflowNameComboBox.getItemAt(nIndex);
                        if (proxyItem == null || VWStringUtils.compare(workflowName, proxyItem.getName()) != 0) continue;
                        this.m_workflowNameComboBox.setSelectedItem(proxyItem);
                        break;
                    }
                } else {
                    this.m_workflowNameComboBox.setSelectedIndex(0);
                }
                this.m_workflowNameComboBox.addActionListener(this);
                this.setWorkflowInfo();
                this.m_workflowNameComboBox.setEnabled(cbModel.getSize() != 0);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void setWorkflowInfo() {
        String type = "";
        try {
            VWSession session;
            if (this.m_authPropertyData != null && (session = this.m_authPropertyData.getVWSession()) != null) {
                VWWorkClassProxy workClassProxy = (VWWorkClassProxy)this.m_workflowNameComboBox.getSelectedItem();
                this.m_assignmentLValueCellEditor.setWorkClassProxy(workClassProxy);
                this.m_assignmentRValueCellEditor.setWorkClassProxy(workClassProxy);
                VWWorkflowSignature wfSignature = workClassProxy.getWorkflowSignature();
                if (wfSignature != null) {
                    String tag = wfSignature.getFTagExpression();
                    this.m_conditionIdentifierTextField.setText(tag);
                    int ftagType = wfSignature.getFTagType();
                    type = ftagType > 0 ? VWFieldType.getLocalizedString(ftagType) : VWResource.s_undefinedStr;
                    this.m_expressionDataTypeTextField.setText(type);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initOperatorComboBox() {
        try {
            this.m_operatorComboBox.removeAllItems();
            this.m_operatorComboBox.removeActionListener(this);
            this.m_operatorComboBox.addItem(VWResource.s_isEqualOp);
            this.m_operatorComboBox.addItem(VWResource.s_notEqualOp);
            this.m_operatorComboBox.addItem(VWResource.s_isGreaterThanOp);
            this.m_operatorComboBox.addItem(VWResource.s_isGreaterThanOrEqualOp);
            this.m_operatorComboBox.addItem(VWResource.s_isLessThanOp);
            this.m_operatorComboBox.addItem(VWResource.s_isLessThanOrEqualOp);
            String comparisonOperator = this.m_eventDef.getComparisonOperator();
            if (comparisonOperator != null) {
                int index = 0;
                if (VWStringUtils.compare(comparisonOperator, "=") == 0) {
                    index = 0;
                } else if (VWStringUtils.compare(comparisonOperator, "<>") == 0) {
                    index = 1;
                } else if (VWStringUtils.compare(comparisonOperator, ">") == 0) {
                    index = 2;
                } else if (VWStringUtils.compare(comparisonOperator, ">=") == 0) {
                    index = 3;
                } else if (VWStringUtils.compare(comparisonOperator, "<") == 0) {
                    index = 4;
                } else if (VWStringUtils.compare(comparisonOperator, "<=") == 0) {
                    index = 5;
                }
                this.m_operatorComboBox.setSelectedIndex(index);
            } else {
                this.m_operatorComboBox.addActionListener(this);
                this.m_operatorComboBox.setSelectedIndex(0);
                this.m_operatorComboBox.removeActionListener(this);
            }
            this.m_operatorComboBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initMapComboBox() {
        Object[] mapNames = null;
        Vector<Object> mapNamesVec = new Vector<Object>();
        this.m_mapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                String mapName;
                Object mapName2;
                int i;
                this.m_mapComboBox.removeAllItems();
                this.m_mapComboBox.addItem(VWResource.s_noneItemStr);
                this.m_mapComboBox.addItem("Workflow");
                this.m_mapComboBox.addItem("Malfunction");
                this.m_mapComboBox.addItem("Terminate");
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (i = 0; i < len; ++i) {
                        mapName2 = mapDefs[i].getName();
                        if (VWStringUtils.compare((String)mapName2, "Workflow") == 0 || VWStringUtils.compare((String)mapName2, "Malfunction") == 0 || VWStringUtils.compare((String)mapName2, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName2);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQuickSort sortMap = new VWQuickSort(mapNames, 0);
                    sortMap.sort(0, mapNames.length);
                    for (i = 0; i < mapNames.length; ++i) {
                        mapName2 = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName2, "") == 0) continue;
                        this.m_mapComboBox.addItem(mapName2);
                    }
                }
                if ((mapName = this.m_eventDef.getCallISName()) != null) {
                    this.m_mapComboBox.setSelectedItem(mapName);
                } else {
                    this.m_mapComboBox.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_mapComboBox.addActionListener(this);
    }

    private void initExpressionControl() {
        try {
            String expression = this.m_eventDef.getValue();
            this.m_expressionTextField.removeExpressionTextFieldListener(this);
            this.m_expressionTextField.setText(expression);
            this.m_expressionTextField.addExpressionTextFieldListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performMapAction() {
        try {
            String mapName = this.m_mapComboBox.getSelectedItem().toString();
            if (VWStringUtils.compare(mapName, VWResource.s_noneItemStr) == 0) {
                mapName = null;
            }
            this.m_authPropertyData.setDirty();
            this.m_eventDef.setCallISName(mapName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performWorkflowNameAction() {
        try {
            VWWorkClassProxy workClassProxy = (VWWorkClassProxy)this.m_workflowNameComboBox.getSelectedItem();
            this.m_eventDef.setWorkClassName(workClassProxy.getName());
            this.m_authPropertyData.setDirty();
            this.setWorkflowInfo();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOperationAction() {
        try {
            String op = "=";
            String comparisonOperator = this.m_operatorComboBox.getSelectedItem().toString();
            if (VWStringUtils.compare(comparisonOperator, VWResource.s_isEqualOp) == 0) {
                op = "=";
            } else if (VWStringUtils.compare(comparisonOperator, VWResource.s_notEqualOp) == 0) {
                op = "<>";
            } else if (VWStringUtils.compare(comparisonOperator, VWResource.s_isGreaterThanOp) == 0) {
                op = ">";
            } else if (VWStringUtils.compare(comparisonOperator, VWResource.s_isGreaterThanOrEqualOp) == 0) {
                op = ">=";
            } else if (VWStringUtils.compare(comparisonOperator, VWResource.s_isLessThanOp) == 0) {
                op = "<";
            } else if (VWStringUtils.compare(comparisonOperator, VWResource.s_isLessThanOrEqualOp) == 0) {
                op = "<=";
            }
            this.m_eventDef.setComparisonOperator(op);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onExpressionUpdated() {
        try {
            String expression = this.m_expressionTextField.getText();
            this.m_eventDef.setValue(expression);
            this.m_authPropertyData.setDirty();
            if (expression != "") {
                this.m_expressionTextField.setToolTipText(expression);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performMoveUpAction() {
        int rowIndex = this.m_assignmentsTable.getSelectedRow();
        if (rowIndex > 0) {
            this.m_assignmentsTableModel.up(rowIndex);
            this.m_assignmentsTable.setRowSelectionInterval(rowIndex - 1, rowIndex - 1);
        }
    }

    private void performMoveDownAction() {
        int rowIndex = this.m_assignmentsTable.getSelectedRow();
        if (rowIndex >= 0) {
            this.m_assignmentsTableModel.down(rowIndex);
            this.m_assignmentsTable.setRowSelectionInterval(rowIndex + 1, rowIndex + 1);
        }
    }

    private void performDeleteAction() {
        int rowIndex = this.m_assignmentsTable.getSelectedRow();
        this.m_assignmentsTableModel.deleteItem(rowIndex);
    }
}

